let wasm;

const cachedTextDecoder = (typeof TextDecoder !== 'undefined' ? new TextDecoder('utf-8', { ignoreBOM: true, fatal: true }) : { decode: () => { throw Error('TextDecoder not available') } } );

if (typeof TextDecoder !== 'undefined') { cachedTextDecoder.decode(); };

let cachedUint8ArrayMemory0 = null;

function getUint8ArrayMemory0() {
	if (cachedUint8ArrayMemory0 === null || cachedUint8ArrayMemory0.byteLength === 0) {
		cachedUint8ArrayMemory0 = new Uint8Array(wasm.memory.buffer);
	}
	return cachedUint8ArrayMemory0;
}

function getStringFromWasm0(ptr, len) {
	ptr = ptr >>> 0;
	return cachedTextDecoder.decode(getUint8ArrayMemory0().subarray(ptr, ptr + len));
}

const CLOSURE_DTORS = (typeof FinalizationRegistry === 'undefined')
	? { register: () => {}, unregister: () => {} }
	: new FinalizationRegistry(state => {
	wasm.__wbindgen_export_1.get(state.dtor)(state.a, state.b)
});

function makeMutClosure(arg0, arg1, dtor, f) {
	const state = { a: arg0, b: arg1, cnt: 1, dtor };
	const real = (...args) => {
		// First up with a closure we increment the internal reference
		// count. This ensures that the Rust closure environment won't
		// be deallocated while we're invoking it.
		state.cnt++;
		const a = state.a;
		state.a = 0;
		try {
			return f(a, state.b, ...args);
		} finally {
			if (--state.cnt === 0) {
				wasm.__wbindgen_export_1.get(state.dtor)(a, state.b);
				CLOSURE_DTORS.unregister(state);
			} else {
				state.a = a;
			}
		}
	};
	real.original = state;
	CLOSURE_DTORS.register(real, state, state);
	return real;
}
function __wbg_adapter_24(arg0, arg1, arg2) {
	wasm.closure38_externref_shim(arg0, arg1, arg2);
}

let WASM_VECTOR_LEN = 0;

const cachedTextEncoder = (typeof TextEncoder !== 'undefined' ? new TextEncoder('utf-8') : { encode: () => { throw Error('TextEncoder not available') } } );

const encodeString = (typeof cachedTextEncoder.encodeInto === 'function'
	? function (arg, view) {
	return cachedTextEncoder.encodeInto(arg, view);
}
	: function (arg, view) {
	const buf = cachedTextEncoder.encode(arg);
	view.set(buf);
	return {
		read: arg.length,
		written: buf.length
	};
});

function passStringToWasm0(arg, malloc, realloc) {

	if (realloc === undefined) {
		const buf = cachedTextEncoder.encode(arg);
		const ptr = malloc(buf.length, 1) >>> 0;
		getUint8ArrayMemory0().subarray(ptr, ptr + buf.length).set(buf);
		WASM_VECTOR_LEN = buf.length;
		return ptr;
	}

	let len = arg.length;
	let ptr = malloc(len, 1) >>> 0;

	const mem = getUint8ArrayMemory0();

	let offset = 0;

	for (; offset < len; offset++) {
		const code = arg.charCodeAt(offset);
		if (code > 0x7F) break;
		mem[ptr + offset] = code;
	}

	if (offset !== len) {
		if (offset !== 0) {
			arg = arg.slice(offset);
		}
		ptr = realloc(ptr, len, len = offset + arg.length * 3, 1) >>> 0;
		const view = getUint8ArrayMemory0().subarray(ptr + offset, ptr + len);
		const ret = encodeString(arg, view);

		offset += ret.written;
		ptr = realloc(ptr, len, offset, 1) >>> 0;
	}

	WASM_VECTOR_LEN = offset;
	return ptr;
}
/**
 * @param {string} header_s
 * @param {number} nr
 * @returns {string}
 */
export function token_request(header_s, nr) {
	let deferred2_0;
	let deferred2_1;
	try {
		const ptr0 = passStringToWasm0(header_s, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
		const len0 = WASM_VECTOR_LEN;
		const ret = wasm.token_request(ptr0, len0, nr);
		deferred2_0 = ret[0];
		deferred2_1 = ret[1];
		return getStringFromWasm0(ret[0], ret[1]);
	} finally {
		wasm.__wbindgen_free(deferred2_0, deferred2_1, 1);
	}
}

/**
 * @param {string} header_s
 * @param {string} client_state_s
 * @param {string} token_response_s
 * @returns {Promise<string>}
 */
export function token_finalization(header_s, client_state_s, token_response_s) {
	const ptr0 = passStringToWasm0(header_s, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
	const len0 = WASM_VECTOR_LEN;
	const ptr1 = passStringToWasm0(client_state_s, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
	const len1 = WASM_VECTOR_LEN;
	const ptr2 = passStringToWasm0(token_response_s, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
	const len2 = WASM_VECTOR_LEN;
	const ret = wasm.token_finalization(ptr0, len0, ptr1, len1, ptr2, len2);
	return ret;
}

function notDefined(what) { return () => { throw new Error(`${what} is not defined`); }; }

function addToExternrefTable0(obj) {
	const idx = wasm.__externref_table_alloc();
	wasm.__wbindgen_export_0.set(idx, obj);
	return idx;
}

function handleError(f, args) {
	try {
		return f.apply(this, args);
	} catch (e) {
		const idx = addToExternrefTable0(e);
		wasm.__wbindgen_exn_store(idx);
	}
}
function __wbg_adapter_53(arg0, arg1, arg2, arg3) {
	wasm.closure277_externref_shim(arg0, arg1, arg2, arg3);
}

async function __wbg_load(module, imports) {
	if (typeof Response === 'function' && module instanceof Response) {
		if (typeof WebAssembly.instantiateStreaming === 'function') {
			try {
				return await WebAssembly.instantiateStreaming(module, imports);

			} catch (e) {
				if (module.headers.get('Content-Type') != 'application/wasm') {
					console.warn("`WebAssembly.instantiateStreaming` failed because your server does not serve Wasm with `application/wasm` MIME type. Falling back to `WebAssembly.instantiate` which is slower. Original error:\n", e);

				} else {
					throw e;
				}
			}
		}

		const bytes = await module.arrayBuffer();
		return await WebAssembly.instantiate(bytes, imports);

	} else {
		const instance = await WebAssembly.instantiate(module, imports);

		if (instance instanceof WebAssembly.Instance) {
			return { instance, module };

		} else {
			return instance;
		}
	}
}

function __wbg_get_imports() {
	const imports = {};
	imports.wbg = {};
	imports.wbg.__wbindgen_string_new = function(arg0, arg1) {
		const ret = getStringFromWasm0(arg0, arg1);
		return ret;
	};
	imports.wbg.__wbg_queueMicrotask_848aa4969108a57e = function(arg0) {
		const ret = arg0.queueMicrotask;
		return ret;
	};
	imports.wbg.__wbindgen_is_function = function(arg0) {
		const ret = typeof(arg0) === 'function';
		return ret;
	};
	imports.wbg.__wbindgen_cb_drop = function(arg0) {
		const obj = arg0.original;
		if (obj.cnt-- == 1) {
			obj.a = 0;
			return true;
		}
		const ret = false;
		return ret;
	};
	imports.wbg.__wbg_queueMicrotask_c5419c06eab41e73 = typeof queueMicrotask == 'function' ? queueMicrotask : notDefined('queueMicrotask');
	imports.wbg.__wbg_crypto_1d1f22824a6a080c = function(arg0) {
		const ret = arg0.crypto;
		return ret;
	};
	imports.wbg.__wbindgen_is_object = function(arg0) {
		const val = arg0;
		const ret = typeof(val) === 'object' && val !== null;
		return ret;
	};
	imports.wbg.__wbg_process_4a72847cc503995b = function(arg0) {
		const ret = arg0.process;
		return ret;
	};
	imports.wbg.__wbg_versions_f686565e586dd935 = function(arg0) {
		const ret = arg0.versions;
		return ret;
	};
	imports.wbg.__wbg_node_104a2ff8d6ea03a2 = function(arg0) {
		const ret = arg0.node;
		return ret;
	};
	imports.wbg.__wbindgen_is_string = function(arg0) {
		const ret = typeof(arg0) === 'string';
		return ret;
	};
	imports.wbg.__wbg_require_cca90b1a94a0255b = function() { return handleError(function () {
		const ret = module.require;
		return ret;
	}, arguments) };
	imports.wbg.__wbg_msCrypto_eb05e62b530a1508 = function(arg0) {
		const ret = arg0.msCrypto;
		return ret;
	};
	imports.wbg.__wbg_randomFillSync_5c9c955aa56b6049 = function() { return handleError(function (arg0, arg1) {
		arg0.randomFillSync(arg1);
	}, arguments) };
	imports.wbg.__wbg_getRandomValues_3aa56aa6edec874c = function() { return handleError(function (arg0, arg1) {
		arg0.getRandomValues(arg1);
	}, arguments) };
	imports.wbg.__wbg_newnoargs_1ede4bf2ebbaaf43 = function(arg0, arg1) {
		const ret = new Function(getStringFromWasm0(arg0, arg1));
		return ret;
	};
	imports.wbg.__wbg_call_a9ef466721e824f2 = function() { return handleError(function (arg0, arg1) {
		const ret = arg0.call(arg1);
		return ret;
	}, arguments) };
	imports.wbg.__wbg_self_bf91bf94d9e04084 = function() { return handleError(function () {
		const ret = self.self;
		return ret;
	}, arguments) };
	imports.wbg.__wbg_window_52dd9f07d03fd5f8 = function() { return handleError(function () {
		const ret = window.window;
		return ret;
	}, arguments) };
	imports.wbg.__wbg_globalThis_05c129bf37fcf1be = function() { return handleError(function () {
		const ret = globalThis.globalThis;
		return ret;
	}, arguments) };
	imports.wbg.__wbg_global_3eca19bb09e9c484 = function() { return handleError(function () {
		const ret = global.global;
		return ret;
	}, arguments) };
	imports.wbg.__wbindgen_is_undefined = function(arg0) {
		const ret = arg0 === undefined;
		return ret;
	};
	imports.wbg.__wbg_call_3bfa248576352471 = function() { return handleError(function (arg0, arg1, arg2) {
		const ret = arg0.call(arg1, arg2);
		return ret;
	}, arguments) };
	imports.wbg.__wbg_new_1073970097e5a420 = function(arg0, arg1) {
		try {
			var state0 = {a: arg0, b: arg1};
			var cb0 = (arg0, arg1) => {
				const a = state0.a;
				state0.a = 0;
				try {
					return __wbg_adapter_53(a, state0.b, arg0, arg1);
				} finally {
					state0.a = a;
				}
			};
			const ret = new Promise(cb0);
			return ret;
		} finally {
			state0.a = state0.b = 0;
		}
	};
	imports.wbg.__wbg_resolve_0aad7c1484731c99 = function(arg0) {
		const ret = Promise.resolve(arg0);
		return ret;
	};
	imports.wbg.__wbg_then_748f75edfb032440 = function(arg0, arg1) {
		const ret = arg0.then(arg1);
		return ret;
	};
	imports.wbg.__wbg_buffer_ccaed51a635d8a2d = function(arg0) {
		const ret = arg0.buffer;
		return ret;
	};
	imports.wbg.__wbg_newwithbyteoffsetandlength_7e3eb787208af730 = function(arg0, arg1, arg2) {
		const ret = new Uint8Array(arg0, arg1 >>> 0, arg2 >>> 0);
		return ret;
	};
	imports.wbg.__wbg_new_fec2611eb9180f95 = function(arg0) {
		const ret = new Uint8Array(arg0);
		return ret;
	};
	imports.wbg.__wbg_set_ec2fcf81bc573fd9 = function(arg0, arg1, arg2) {
		arg0.set(arg1, arg2 >>> 0);
	};
	imports.wbg.__wbg_newwithlength_76462a666eca145f = function(arg0) {
		const ret = new Uint8Array(arg0 >>> 0);
		return ret;
	};
	imports.wbg.__wbg_subarray_975a06f9dbd16995 = function(arg0, arg1, arg2) {
		const ret = arg0.subarray(arg1 >>> 0, arg2 >>> 0);
		return ret;
	};
	imports.wbg.__wbindgen_throw = function(arg0, arg1) {
		throw new Error(getStringFromWasm0(arg0, arg1));
	};
	imports.wbg.__wbindgen_memory = function() {
		const ret = wasm.memory;
		return ret;
	};
	imports.wbg.__wbindgen_closure_wrapper131 = function(arg0, arg1, arg2) {
		const ret = makeMutClosure(arg0, arg1, 39, __wbg_adapter_24);
		return ret;
	};
	imports.wbg.__wbindgen_init_externref_table = function() {
		const table = wasm.__wbindgen_export_0;
		const offset = table.grow(4);
		table.set(0, undefined);
		table.set(offset + 0, undefined);
		table.set(offset + 1, null);
		table.set(offset + 2, true);
		table.set(offset + 3, false);
		;
	};

	return imports;
}

function __wbg_init_memory(imports, memory) {

}

function __wbg_finalize_init(instance, module) {
	wasm = instance.exports;
	__wbg_init.__wbindgen_wasm_module = module;
	cachedUint8ArrayMemory0 = null;


	wasm.__wbindgen_start();
	return wasm;
}

function initSync(module) {
	if (wasm !== undefined) return wasm;


	if (typeof module !== 'undefined') {
		if (Object.getPrototypeOf(module) === Object.prototype) {
			({module} = module)
		} else {
			console.warn('using deprecated parameters for `initSync()`; pass a single object instead')
		}
	}

	const imports = __wbg_get_imports();

	__wbg_init_memory(imports);

	if (!(module instanceof WebAssembly.Module)) {
		module = new WebAssembly.Module(module);
	}

	const instance = new WebAssembly.Instance(module, imports);

	return __wbg_finalize_init(instance, module);
}

async function __wbg_init(module_or_path) {
	if (wasm !== undefined) return wasm;


	if (typeof module_or_path !== 'undefined') {
		if (Object.getPrototypeOf(module_or_path) === Object.prototype) {
			({module_or_path} = module_or_path)
		} else {
			console.warn('using deprecated parameters for the initialization function; pass a single object instead')
		}
	}

	if (typeof module_or_path === 'undefined') {
		module_or_path = new URL('kagippjs_bg.wasm', import.meta.url);
	}
	const imports = __wbg_get_imports();

	if (typeof module_or_path === 'string' || (typeof Request === 'function' && module_or_path instanceof Request) || (typeof URL === 'function' && module_or_path instanceof URL)) {
		module_or_path = fetch(module_or_path);
	}

	__wbg_init_memory(imports);

	const { instance, module } = await __wbg_load(await module_or_path, imports);

	return __wbg_finalize_init(instance, module);
}

export { initSync };
export default __wbg_init;


window.kagippjs = {};
window.kagippjs.init = __wbg_init;
window.kagippjs.token_request = token_request;
window.kagippjs.token_finalization = token_finalization;
