function fetchTextForReaderModeOffset() {
	var topleftElement = {
		el: null,
		offset: {
		  x: Number.MAX_SAFE_INTEGER,
		  y: Number.MAX_SAFE_INTEGER
		}
	};
	function distanceFromTopOfViewport(node) {
		var rect = node.getBoundingClientRect();

		if (
		  rect.top >= 0 &&
		  rect.left >= 0 &&
		  rect.width >= 50 &&
		  rect.height >= 10 &&
		  rect.bottom <= (window.innerHeight || document.documentElement.clientHeight) && /* or $(window).height() */
		  rect.right <= (window.innerWidth || document.documentElement.clientWidth) /* or $(window).width() */
		) {
		  return { x: rect.left, y: rect.top }
		} else {
		  return { x: -1, y: -1 }
		}
	}
	function isHidden(el) {
		var style = window.getComputedStyle(el);
		var rect = el.getBoundingClientRect();
		return ((style.display === 'none') || (style.visibility === 'hidden') || (rect.width < 50) || (rect.height < 10) );
	}
	// Check all <p> tags. Hard to do better than this. More tags take more time and introduce the possibility that we are trying to match text in a random <b> tag in an advertisement instead of in an article's text
	const index = -1
	document.body.querySelectorAll("p").forEach(function(el, innerIndex) {
		if ((isHidden(el) == true) || (el.closest('iframe') != null)) {
			return;
		}
		var offset = distanceFromTopOfViewport(el)
		if (offset.x >= 0 && offset.y >= 0 && offset.x < topleftElement.offset.x && offset.y < topleftElement.offset.y) {
			index = innerIndex
			topleftElement.el = el
			topleftElement.offset = offset
		}
	});
	if index == 0 {
		return "";
	} else if (topleftElement.el != null) {
		return topleftElement.el.innerText.substring(0,150);
	}
	else {
		return "";
	}
}
fetchTextForReaderModeOffset();